#!/bin/bash

set -ex

BUDGET=10
POPSIZE=10
NUM_OF_MANUAL=10
template=v1
llm=davinci
initial=all
initial_mode=para_topk

for task in date_understanding
do
for SIZE in 10
do
POPSIZE=$SIZE
NUM_OF_MANUAL=$SIZE
OUT_PATH=outputs/$task/$initial/ga/bd${BUDGET}_top${NUM_OF_MANUAL}_${initial_mode}_init_consis/$template/$llm
for seed in 10
do
mkdir -p $OUT_PATH/seed${seed}
cache_path=cache/$task/seed$seed
mkdir -p $cache_path
python run.py \
    --seed $seed \
    --task $task \
    --batch-size 20 \
    --sample_num 50 \
    --budget $BUDGET \
    --popsize $POPSIZE \
    --num_of_manual $NUM_OF_MANUAL \
    --evo_mode ga \
    --llm_type $llm \
    --setting mt \
    --initial $initial \
    --initial_mode $initial_mode \
    --client \
    --consis \
    --template $template \
    --cache_path $cache_path/prompts_consis_$llm.json \
    --output $OUT_PATH/seed${seed}
done
done
done