import argparse

def parse_args():
    parser = argparse.ArgumentParser(description='training args.')

    # prompt args
    parser.add_argument('--dataset',
                        type=str,
                        default='sst2',
                        help='dataset name')
    parser.add_argument('--task', type=str, choices=['cls', 'mt', 'sum', 'sim','qa', 'style'])
    parser.add_argument('--do_test', action='store_true')
    parser.add_argument('--test_file', type=str, default=None)
    parser.add_argument(
        '--data-store',
        type=str,
        help='path to the dataset to select demonstrations from')
    parser.add_argument('--batch-size',
                        type=int,
                        default=16,
                        help='batchsize in decoding. Left padding in default')
    parser.add_argument('--max-new-tokens',
                        type=int,
                        default=128,
                        help='max new tokens to generate by the model')
    parser.add_argument('--prompt-num',
                        type=int,
                        default=0,
                        help='number of prompts')
    parser.add_argument('--dev_file',
                        type=str,
                        default=None,)
    parser.add_argument('--output',
                        type=str,
                        default=None,
                        help='output file name')

    parser.add_argument('--language_model', type=str, help='opt model names')
    parser.add_argument('--position', type=str, default='pre')
    parser.add_argument('--random_data',
                        type=int,
                        default=0,
                        help='whether to random data when evaluating')
    parser.add_argument(
        '--sample_num',
        type=int,
        default=100,
        help='number of samples used to choose the optimized sequences')

    # DE args
    parser.add_argument('--budget', type=int, default=10)
    parser.add_argument('--num_of_manual',
                        type=int,
                        default=5,
                        help='number of manually written prompts')
    parser.add_argument('--popsize', type=int, default=10)
    parser.add_argument('--evo_mode', type=str, default='vae', help='mode of the evolution', choices=['de', 'para', 'vae', 'para_de', 'random', 'ga', 'random_v3'])
    parser.add_argument('--llm_type', type=str, default='davinci')
    parser.add_argument('--initial', type=str, default='manual', choices=['ape', 'manual', 'all', 'ckpt'])
    parser.add_argument('--initial_mode', type=str)
    parser.add_argument('--para_mode', type=str, default=None)
    parser.add_argument('--eval_set', type=str, choices=['dev', 'test'], default='dev')
    parser.add_argument('--de_shot', type=int, default=1)
    parser.add_argument('--dev_reduce', action='store_true')
    parser.add_argument('--num_shot', type=int, default=0)
    parser.add_argument('--ckpt_pop', type=str, default=None)
    parser.add_argument('--template', type=str, default='v1')
    parser.add_argument('--pred_mode', type=str, default='logits')
    parser.add_argument('--client', action='store_true'),
    parser.add_argument('--metric', type=str, choices=['bleu', 'comet'], help='used for mt tasks')
    parser.add_argument('--cache_path', type=str, default=None)
    parser.add_argument('--mode', type=str)
    parser.add_argument('--setting', type=str, default=None)
    parser.add_argument('--donor_random', action='store_true')
    parser.add_argument('--ga_mode', type=str, default='std')
    parser.add_argument('--content', type=str, default='')
    parser.add_argument('--write_step', type=int, default=10)
    parser.add_argument('--sel_mode', type=str, choices=['wheel', 'random', 'tour'], default='wheel')
    args = parser.parse_args()
    return args