import os

from evolution import ape, gpt_evo, ga_evo
from utils import set_seed
from evaluator import CLSEvaluator, SimEvaluator, SumEvaluator
from args import parse_args


def run(args):
    set_seed(args.seed)
    dataset = args.dataset
    args.data_store = f"./data/{args.task}/datastore.{dataset}"

    # print(args)
    task2evaluator = {
        "cls": CLSEvaluator,
        "sum": SumEvaluator,
        "sim": SimEvaluator,
    }
    evaluator = task2evaluator[args.task](args)

    evaluator.logger.info(
        "---------------------Evoluting prompt-------------------\n"
    )
    if args.evo_mode == "para" and args.para_mode == "topk":
        ape(args=args, evaluator=evaluator)
    elif args.evo_mode in ["de"]:
        gpt_evo(args=args, evaluator=evaluator)
    elif args.evo_mode == 'ga':
        ga_evo(args=args, evaluator=evaluator)


if __name__ == "__main__":
    args = parse_args()
    run(args)
