#!/bin/bash

set -ex

export CUBLAS_WORKSPACE_CONFIG=:16:8  
export CUDA_VISIBLE_DEVICES=2

BUDGET=10
POPSIZE=10
NUM_OF_MANUAL=10
SEED=5
TEMPLATE=v9
initial_mode=para_topk

for dataset in subj
do
OUT_PATH=outputs/cls/$dataset/alpaca/all/de/bd${BUDGET}_top${NUM_OF_MANUAL}_${initial_mode}_init/${TEMPLATE}-sim-unify/davinci
for SEED in 15
do
python run.py \
    --seed $SEED \
    --do_test \
    --dataset $dataset \
    --task cls \
    --batch-size 16 \
    --prompt-num 0 \
    --sample_num 500 \
    --language_model alpaca \
    --budget $BUDGET \
    --popsize $POPSIZE \
    --num_of_manual $NUM_OF_MANUAL \
    --random_data 0 \
    --position demon \
    --evo_mode de \
    --llm_type davinci \
    --setting mt \
    --initial all \
    --initial_mode $initial_mode \
    --template $TEMPLATE \
    --output $OUT_PATH/seed$SEED \
    --cache_path data/cls/$dataset/seed${SEED}/prompts_batched.json \
    --dev_file ./data/cls/$dataset/seed${SEED}/dev.txt
done
done