#!/bin/bash

set -ex

export CUBLAS_WORKSPACE_CONFIG=:16:8  
export CUDA_VISIBLE_DEVICES=0

BUDGET=10
POPSIZE=10
NUM_OF_MANUAL=10
SEED=5
GA=topk
TEMPLATE=v1

for dataset in sst2
do
OUT_PATH=outputs/cls/$dataset/alpaca/all/ga/bd${BUDGET}_top${NUM_OF_MANUAL}_para_topk_init/$GA/$TEMPLATE-0905-fix/davinci
for SEED in 5 10 15
do
python run.py \
    --seed $SEED \
    --do_test \
    --dataset $dataset \
    --task cls \
    --batch-size 20 \
    --prompt-num 0 \
    --sample_num 500 \
    --language_model alpaca \
    --budget $BUDGET \
    --popsize $POPSIZE \
    --num_of_manual $NUM_OF_MANUAL \
    --random_data 0 \
    --position demon \
    --evo_mode ga \
    --llm_type davinci \
    --setting mt \
    --initial all \
    --initial_mode para_topk \
    --ga_mode $GA \
    --template $TEMPLATE \
    --cache_path data/cls/$dataset/seed${SEED}/prompts_batched.json \
    --output $OUT_PATH/seed$SEED \
    --dev_file ./data/cls/$dataset/seed${SEED}/dev.txt
done
python get_result.py -p $OUT_PATH > $OUT_PATH/result.txt
done