#!/bin/bash

set -ex

export CUBLAS_WORKSPACE_CONFIG=:16:8  
export CUDA_VISIBLE_DEVICES=0

BUDGET=10

POPSIZE=10
NUM_OF_MANUAL=10
SEED=5
TEMPLATE=v12
initial=all

for dataset in asset
do
OUT_PATH=outputs/sim/$dataset/alpaca/all/de/bd${BUDGET}_top${NUM_OF_MANUAL}_para_topk_init/${TEMPLATE}-sim-unify-cls/davinci
for SEED in 5
do
python run.py \
    --seed $SEED \
    --do_test \
    --dataset $dataset \
    --task sim \
    --batch-size 20 \
    --prompt-num 0 \
    --sample_num 100 \
    --language_model alpaca \
    --budget $BUDGET \
    --popsize $POPSIZE \
    --num_of_manual $NUM_OF_MANUAL \
    --random_data 0 \
    --position pre \
    --evo_mode de \
    --llm_type davinci \
    --initial $initial \
    --setting mt \
    --initial_mode para_topk \
    --cache_path data/sim/$dataset/seed${SEED}/prompts_batched.json \
    --template $TEMPLATE \
    --output $OUT_PATH/seed$SEED
done
done