# Defogging Discrete Flow Matching with Graph Generation
## Environment Installation

1. **Create a new environment using Conda:**
   ```bash
   conda env create -f dependencies/environment.yaml
   ```

2. **Activate the environment:**
   ```bash
   conda activate defog
   ```

3. **Install FCD support for molecules:**
   ```bash
   pip install fcd==1.2 --no-deps
   ```

4. **Install ORCA support for synthetic datasets:**
   ```bash
   cd ./defog/analysis/orca
   g++ -O2 -std=c++11 -o orca orca.cpp
   ```

5. **Install DeFoG:**
   ```bash
   pip install -e .
   ```

## Run the code
  
All code is executed using `python main.py`. Refer to [Hydra's documentation](https://hydra.cc/) for details on overriding default parameters.

- **Debugging**: To run the debugging code, use:
    ```bash
    python3 main.py +experiment=debug.yaml
    ```
    It's recommended to run the debug mode before launching full experiments.
  
- **Run on a Few Batches**: Execute the code on a limited number of batches with:
    ```bash
    python main.py general.name=test
    ```

- **Specify Dataset**: To specify a dataset, use:
    ```bash
    python main.py dataset=guacamol
    ```
    Available datasets can be found in the `configs/dataset` directory.

## Others
- **Sampling:**  
  To sample using a specific checkpoint, set `general.test_only` to the path of the saved checkpoint.

- **Sample:**  
  The control over sampling is configured using arguments in `cfg.sample`.

- **Train:**
  - The initial distribution for training is configured using `cfg.model.limit_distribution`.
  - The training distortion is set up according to `cfg.train.time_distortion`.

- **Sample Strategy Searching:**  
  The search over sampling configurations is enabled using`cfg.sample.search=search`.
