import numpy as np
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt

def get_obs(obs,n_agent):
	for i in range(n_agent):
		index = np.zeros(n_agent)
		index[i] = 1
		obs[i] = np.hstack((obs[i],index))
	return obs

def log_data(f, net, loss, log_r, ep_reward, time_step, writer):
	f.write(str(time_step)+','+str(log_r)+','+'\n')
	f.flush()
	for name, param in net.named_parameters(): 
		writer.add_histogram(name + '_data', param, time_step)
	writer.add_scalar('loss', loss, time_step)
	writer.add_scalar('reward', log_r, time_step)
	writer.add_scalar('train_reward', ep_reward, time_step)


