import torch

# n_diffusion_steps 1000
# action_weight
# loss_weight
# loss_discount
# dim_mults
# dim
# condition_dropout
# condition_guidance_w
# test_ret

class Diffuser_Config:
    # misc
    seed = 100
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    bucket = 'eng/osrl/bucket/weights'
    dataset = 'hammer-v2'

    ## model
    backbone = 'diffuser.models.TemporalUnet'
    diffusion = 'diffuser.models.GaussianDiffusion'
    horizon = 200
    n_diffusion_steps = 1000
    action_weight = 1
    loss_weights = None
    loss_discount = 1
    predict_epsilon = True
    dim_mults = (1, 4, 8)
    input_condition = True
    
    calc_energy=False
    dim=128
    condition_dropout=0.25
    condition_guidance_w = 1.2
    test_ret=0.9
    renderer = 'utils.MuJoCoRenderer'
    n_task=20
    n_trajectories=100

    ## dataset
    loader = 'diffuser.datasets.SequenceDataset'
    normalizer = 'CDFNormalizer'
    preprocess_fns = []
    clip_denoised = True
    use_padding = True
    include_returns = True
    discount = 0.99
    max_path_length = 1000
    hidden_dim = 256
    ar_inv = False
    train_only_inv = False
    termination_penalty = -100
    returns_scale = 400.0 # Determined using rewards from the dataset

    ## training
    n_steps_per_epoch = 10000
    loss_type = 'l2'
    n_train_steps = 1e5
    batch_size = 32
    learning_rate = 2e-4
    gradient_accumulate_every = 2
    ema_decay = 0.995
    log_freq = 1000
    save_freq = 10000
    sample_freq = 10000
    n_saves = 5
    save_parallel = False
    n_reference = 8
    save_checkpoints = True
    diffusion_bc_coef = 0.15
    update_bc_after = 100000
