This repository contains the code and models for our paper:

## Getting started
You can start by following the steps below.

1. Install the dependencies for our code using Conda. You may need to adjust the environment YAML file depending on your setup.

    ```
    conda env create -f environment.yml
    conda activate in-context-learning
    ```

3. [Optional] If you plan to train, populate `conf/wandb.yaml` with you wandb info.

That's it! You can now explore our pre-trained models or train your own. The key entry points
are as follows (starting from `src`):
- The `experiment` folder contains code to load our pre-trained models, plot the pre-computed metrics, and generate data for the experiments from the paper. 
1. **Experiment 1:** Covariance Shift
- `train.py` takes as argument a configuration yaml from `conf` and trains the corresponding model. You can try `python train.py --config conf/toy.yaml` for a quick training run. We used `conf/fix_linear_regression.yaml` to train our `pretrain_complete` model, i.e. `python train.py --config conf/fix_linear_regression.yaml`.