import matplotlib.pyplot as plt

source_path = '/root/weiminwu/in-context-learning-fork/in-context-learning/src/evaluation/results/DT'
figure_path = '/root/weiminwu/in-context-learning-fork/in-context-learning/src/evaluation/figures/DT'

with open(source_path+'/exp_3/w_1.txt', 'r') as file:
    w_1 = [float(line.strip()) for line in file]

with open(source_path+'/exp_3/best.txt', 'r') as file:
    best = [float(line.strip()) for line in file]

with open(source_path+'/exp_3/worst.txt', 'r') as file:
    worst = [float(line.strip()) for line in file]

with open(source_path+'/exp_3/baseline.txt', 'r') as file:
    base_line = [float(line.strip()) for line in file]
    
prompt_length = 76

plt.figure(figsize=(10, 5), facecolor='none')
plt.plot(range(prompt_length), best, label="High Similarity", linewidth=3, color="darkred")
plt.plot(range(prompt_length), w_1, label="Normal Similarity", linewidth=3)
plt.plot(range(prompt_length), worst, label="Low Similarity", linewidth=3)
# plt.plot(range(prompt_length), base_line, label="2-Layer NN", linewidth=3, color="grey")
plt.plot(range(prompt_length), base_line, label="Decision Tree", linewidth=3, color="grey")
x = [0, 25, 50, 75]
plt.xticks(x, fontsize=28)
plt.yticks(fontsize=28)
plt.axhline(1, ls="--", color="darkgrey", linewidth=3)
plt.axvline(x=50, color='darkgrey', linestyle='--', linewidth=3)  # Grey vertical line
plt.legend(loc='lower right', fontsize=22)
plt.xlabel('In-context Examples', fontsize=28)
plt.ylabel('R-Squared', fontsize=28)
plt.grid(color='lightgray', linestyle='-', linewidth=0.5)

# set boardline
plt.gca().spines['right'].set_visible(False)  
plt.gca().spines['top'].set_visible(False)    
plt.gca().spines['left'].set_linewidth(2)  
plt.gca().spines['left'].set_color('black') 
plt.gca().spines['bottom'].set_linewidth(2)
plt.gca().spines['bottom'].set_color('black') 

# safe fig
plt.savefig(figure_path+"/4_3.pdf", bbox_inches = "tight", transparent=True)
plt.show()