# Energy Shields for Fairness

Supplementary material to reproduce the experiments in the paper.

## Running the simulation

The simulation binary now accepts a single JSON configuration file describing all parameters.

1. Compile (requires a C++17 compiler and nlohmann/json single-header available in include path):

   g++ -std=c++17 run_simulation.cc -O2 -o run_simulation.o

   If `nlohmann/json.hpp` is not in your system include path, download the single-header and compile with:

   g++ -std=c++17 run_simulation.cc -O2 -I. -o run_simulation.o

2. Example configuration

   A ready-to-edit example is provided as `config.example.json`. Edit it or create your own JSON file. Example fields:

   - n_simulations (int > 0)
   - n_steps (int > 0)
   - p (float in [0,1])
   - kappa (float in [0,1])
   - energy_type (int; 1 is supported)
   - energy_params or energy1_alpha (optional)
   - naive_shield (bool), aaai_shield (bool)
   - naiveL, naiveU (floats in [0,1])
   - aaaip1 (float in [0,1]), aaaitau (int > 2)

3. Run

   ./run_simulation.o --config config.example.json

   The program will write a CSV `sim_results_...timestamp....csv` with per-step statistics.

## Plotting

A helper script `plot_sim_results.py` reads the produced CSV and can plot outcome and cost metrics:

- Outcome plot (ones/(ones+zeros)): `./plot_sim_results.py sim_results_...csv --out outcome.png`
- Cost plot: `./plot_sim_results.py sim_results_...csv --cost-out cost.png`

The script accepts legacy CSVs that used `base_*` columns.

## Reproducing the paper experiments

This repository includes two standalone programs used to reproduce the experiments reported in the paper.

- `shield_synthesis` (C++): synthesizes shields and times synthesis experiments

  Compile:

  g++ -std=c++17 -O2 shield_synthesis.cc -o shield_synthesis

  Run (default behavior):

  ./shield_synthesis

  What it does:
  - The program runs the synthesis experiments implemented in `synthesis_experiments_paper()` and writes results to `synthesis_results.csv` in the current directory.
  - The console prints progress and timing information. The run may take several minutes depending on parameters; check `synthesis_results.csv` for the final table.

- `prob_and_expectation_compute` (C++): computes exact probabilities / expectations and compares to analytical bounds

  Compile:

  g++ -std=c++17 -O2 prob_and_expectation_compute.cc -o prob_and_expectation_compute

  Run:

  ./prob_and_expectation_compute

  What it does:
  - The program runs two experiments and writes two timestamped CSV files into the current directory:
    - `prob_results_times_YYYYMMDD_HHMMSS.csv` (timing experiment across T values)
    - `prob_results_bound_YYYYMMDD_HHMMSS.csv` (comparison of exact probabilities vs. interval bounds)
  - Each CSV includes columns described by the program header (experiment id, T, tau, exact_prob, bound, elapsed_sec).

Notes and tips

- Both programs are self-contained and only use the C++ standard library; no external dependencies are required to build them.
- If you want to change experiment parameters (e.g. ranges of T, tau, p, safety/limit intervals), edit the corresponding functions in the `.cc` files before compiling.
- These computations can be CPU- and memory-intensive for large T/tau. Reduce the ranges when iterating locally to get faster feedback.