# ToMCAT-ML-Modeling

This repository contains scripts that use a separate fNIRS-CNN and EEG-CNN model to classify valence and arousal from EEG and fNIRS labeled datasets. 

## Package Installation
This project requires specific Python packages to be installed. Please follow the instructions below to set up the environment and install the packages you need.
### Environment Setup
1. Make sure you have Python 3.11.3 installed on your system. You can download Python from the official Python website: https://www.python.org/downloads/
2. Create a new virtual environment for this project (optional but recommended). Open a terminal or command prompt and execute the following command:

```bash
python3 -m venv myenv
```
3. Activate the virtual environment. Execute the appropriate command based on your operating system:
* For Windows:
```bash
myenv\Scripts\activate
```
* For Unix or Linux:
```bash
source myenv/bin/activate
```

### Package Installation
4. Install the required packages using pip. In the activated virtual environment, execute the following command:
```bash
pip install -r requirements.txt
```

## Usage:
### fNIRS:
1. Prepare the dataset: Place your fNIRS dataset file in a directory. Note the path to this directory.
2. Execute the script by running the following command:
```bash
python3 NIRS_affective_individual_task_CNN.py --p  <path_to_nirs_dataset_directory> 
```
Replace `<path_to_dataset_directory>` with the actual path to the directory containing the fNIRS dataset.
Example:
```bash
python3 NIRS_affective_individual_task_CNN.py --p  /tomcat/data/derived/drafts/release_2023_08_28_17/fnirs_10hz/ --offset 0 --window_size 20 --num_epochs 250
```
3. If you wish to pass hyperparameters like num_epochs, batch_size, learning_rate, window_size, offset, etc, you can do so by sending those values as a flag. 
4. The script will load the fNIRS affective task  dataset, preprocess the data, train the CNN model, and evaluate its performance.
5. After completion, the script will display the average accuracy and standard deviation across folds for arousal and valence scores. It will also print the average loss per fold and the standard deviation of loss per fold.
6. Additionally, the script will generate confusion matrix plots for arousal and valence scores and save them in the output folder.

### EEG:
1. Prepare the dataset: Place your EEG dataset file in a directory. Note the path to this directory.
2. Execute the script by running the following command:
```bash
python3 EEG_affective_individual_task_CNN.py --p <path_to_eeg_dataset_directory> 
```
Replace `<path_to_dataset_directory>` with the actual path to the directory containing the EEG dataset.
Example:
```bash
python3 EEG_affective_individual_task_CNN.py --p /tomcat/data/derived/drafts/release_2023_08_28_17/eeg_500hz/ --offset 0 --window_size 1000 --num_epochs 250
```
3. If you wish to pass hyperparameters like num_epochs, batch_size, learning_rate, window_size, offset, etc, you can do so by sending those values as a flag. 
4. The script will load the EEG affective task dataset, preprocess the data, train the CNN model, and evaluate its performance.
5. After completion, the script will display the average accuracy and standard deviation across folds for arousal and valence scores. It will also print the average loss per fold and the standard deviation of loss per fold.
6. Additionally, the script will generate confusion matrix plots for arousal and valence scores and save them in the output folder.

---
**NOTE**
The EEG is recorded at a sampling rate of 500Hz, while the fNIRS is recorded at 10Hz. Therefore, if you wish to consider a window size of 2 seconds, you should pass a value of 1000 for EEG and 20 for fNIRS. 

- `offset`: This parameter allows you to specify the starting point for the data extraction. Setting an offset of 10, for example, would mean that the first 10 rows of data for each unique combination are skipped, and the extraction starts from the 11th row.

- `window_size`: If you set `window_size` to 10, the script will initially select 20 rows of data, as it considers `window_size * 2` rows. Subsequently, a sliding window with a 50% overlap is applied within these 20 rows of data, utilizing a window size of 10.
---

## Optional:
If you wish to execute scripts concurrently with various combinations of window_size and offsets and log results to a csv file, please execute the following commands separately. Ensure to replace <path_to_eeg_dataset_directory> with the appropriate path when running `run_eeg.sh`, and <path_to_nirs_dataset_directory> when running `run_nirs.sh`:
```bash
./run_eeg.sh
```
```bash
./run_nirs.sh
```
