import pandas as pd


def get_experiments_info(
        data_validity_path: str, modal: str, tasks: list[str]
) -> list[dict[str, any]]:
    # # Get the experiments info from the database
    # db = sqlite3.connect(db_path)
    #
    # placeholders = ', '.join(['?'] * len(tasks))
    # query = f"""
    #     SELECT group_session, task, station
    #     FROM data_validity
    #     WHERE participant BETWEEN 0 AND 999
    #     AND modality = ?
    #     AND task IN ({placeholders})
    #     AND is_valid = 1;
    # """
    # params = [modal] + tasks
    # df = pd.read_sql_query(query, db, params=params)
    #
    # db.close()

    df = pd.read_csv(data_validity_path)

    df = df[df['participant'].between(0, 999)]
    df = df[df['is_valid'] == 1]
    df = df[df['modality'] == modal]
    df = df[df['task'].isin(tasks)]

    # Organize the experiments info from the dataframe
    group_sessions = df['group_session'].unique()

    experiments_info = []
    for session in group_sessions:
        tasks_info = []
        for task in tasks:
            stations = df[(df['group_session'] == session) & (df['task'] == task)]['station'].unique().tolist()
            if len(stations) == 0:
                continue

            tasks_info.append({
                "task_name": task,
                "stations": stations
            })

        experiments_info.append({
            "experiment_name": session,
            "tasks": tasks_info,
            "modal": modal
        })

    experiments_info.sort(key=lambda x: x['experiment_name'])

    return experiments_info
