def report_experiments_considered(experiments_channel_correlation_score: list[dict[str, any]]):
    task_channel_experiment_considered = {}

    for experiment in experiments_channel_correlation_score:
        experiment_name = experiment['experiment_name']

        for task in experiment['task_correlation_results']:
            task_name = task['task_name']

            if task_name not in task_channel_experiment_considered:
                task_channel_experiment_considered[task_name] = {}

            task_score = task['score']

            for channel, correlation in task['correlation_per_channel'].items():
                if correlation is None:
                    print(f"{task_name} {experiment_name} {channel} Skipped due to None correlation")
                    continue

                if task_name == "ping_pong_cooperative" and task_score > 20:
                    print(f"{task_name} {experiment_name} {channel} Skipped due to {task_score} score too high")
                    continue

                if channel not in task_channel_experiment_considered[task_name]:
                    task_channel_experiment_considered[task_name][channel] = []

                task_channel_experiment_considered[task_name][channel].append(experiment_name)

    for task in ["ping_pong_cooperative", "saturn_a", "saturn_b"]:
        if task not in task_channel_experiment_considered:
            continue

        print(f"\nTask: {task}, {len(task_channel_experiment_considered[task])} channels")
        for channel, experiments in task_channel_experiment_considered[task].items():
            print(f"{channel}: {len(experiments)} experiments")
