import os

from common import get_experiments_info, read_signal_data_all
from config import DATA_VALIDITY_PATH, NUM_PROCESSES, SIGNAL_PATH, FNIRS_CHANNELS
from report import report_experiments_considered
from signal_correlation import (
    compute_channel_correlation_score_all,
    get_task_correlate_score,
    regress_channel_correlation_score,
    write_correlation_results,
    plot_regression
)

if __name__ == "__main__":
    tasks = [
        "ping_pong_cooperative",
        "saturn_a",
        "saturn_b"
    ]
    modal = "fnirs"

    experiments_info = get_experiments_info(DATA_VALIDITY_PATH, modal, tasks)

    signal_path = os.path.join(SIGNAL_PATH, "fnirs_10hz")
    experiments_data = read_signal_data_all(signal_path, experiments_info, NUM_PROCESSES)

    experiments_channel_correlation_score = compute_channel_correlation_score_all(
        experiments_data, FNIRS_CHANNELS, NUM_PROCESSES
    )

    report_experiments_considered(experiments_channel_correlation_score)

    task_correlation_score = get_task_correlate_score(experiments_channel_correlation_score)

    regression_results = regress_channel_correlation_score(task_correlation_score)

    plot_regression(regression_results, "images/fnirs")

    write_correlation_results(regression_results, f"./correlation_results_{modal}.xlsx")
