def get_task_correlate_score(experiments_channel_correlation_score: list[dict[str, any]]) -> dict:
    task_data = {}

    for experiment in experiments_channel_correlation_score:
        tasks_correlation_score = experiment['task_correlation_results']

        for task_correlation_score in tasks_correlation_score:
            task_score = task_correlation_score["score"]
            task_correlation_per_channel = task_correlation_score["correlation_per_channel"]

            if task_correlation_score["task_name"] not in task_data:
                task_data[task_correlation_score["task_name"]] = {
                    "channels": {},
                    "score": []
                }

            task_data[task_correlation_score["task_name"]]["score"].append(task_score)

            for channel, correlation in task_correlation_per_channel.items():
                if channel not in task_data[task_correlation_score["task_name"]]["channels"]:
                    task_data[task_correlation_score["task_name"]]["channels"][channel] = []

                task_data[task_correlation_score["task_name"]]["channels"][channel].append(correlation)

    return task_data
