import os

import pandas as pd


def write_correlation_results(correlation_results: dict, output_file: str):
    frames = []

    for task, results in correlation_results.items():
        if results["linear_regression_slope_per_channel"].keys() != results["r2_per_channel"].keys():
            raise ValueError("The keys in both dictionaries must match")

        channels = list(results["r2_per_channel"].keys())
        slopes = [results["linear_regression_slope_per_channel"][channel] for channel in channels]
        r2 = [results["r2_per_channel"][channel] for channel in channels]
        null_model_r2 = [results["null_model_r2"] for _ in channels]
        p_values = [results["p_value_per_channel"][channel] for channel in channels]
        cross_validation_mean_error = [results["cross_validation_mean_error_per_channel"][channel]
                                       for channel in channels]
        cross_validation_std_error = [results["cross_validation_std_error_per_channel"][channel]
                                      for channel in channels]

        # Create a DataFrame with multi-level columns
        df = pd.DataFrame({
            ('task', task, 'channels'): channels,
            ('task', task, 'slopes'): slopes,
            ('task', task, 'r2'): r2,
            ('task', task, 'null_model'): null_model_r2,
            ('task', task, 'p_values'): p_values,
            ('task', task, 'cross_validation_mean_error'): cross_validation_mean_error,
            ('task', task, 'cross_validation_std_error'): cross_validation_std_error,
        })
        frames.append(df)

    # Concatenate the DataFrames
    final_df = pd.concat(frames, axis=1)

    # Define the multi-level columns
    final_df.columns = pd.MultiIndex.from_tuples(final_df.columns)

    final_df.to_excel(output_file)
