## Installation

```
python=3.6
numpy
scipy
scikit-learn
pytorch=1.4.0
pandas
```


## Reproducing results for SCOP 1.75

To reproduce the results in Table 2, run the following commands.

* Downloading data (comment / uncomment the tool needed between 
wget and curl)
    ```bash
    cd data
    bash get_data.sh
    ```

* Unsupervised learning with OTKE for SCOP 1.75 (85.7/95.3/96.7)
    ```bash
    export PYTHONPATH=$PWD
    python scop175_unsup.py --n-filters 1024 --out-size 100
    ```

* Supervised learning with OTKE for SCOP 1.75 (resp. 88.4/95.8/97.1 and 88.7/95.9/97.3)
    ```bash
    export PYTHONPATH=$PWD
    # OTK with one reference
    python scop175_sup.py --n-filters 512 --heads 1 --out-size 50 --alternating
    # OTK with multiple references
    python scop175_sup.py --n-filters 512 --heads 5 --out-size 10 --alternating
    ```

## Reproducing results for DeepSEA

To reproduce the results (auROC=0.936, auPRC=0.360) in Table 3, run the following commands.
A pre-trained model will be made available if the paper is accepted.

* Downloading data
    ```bash
    cd data
    bash get_data2.sh
    ```

* Training
    ```bash
    export PYTHONPATH=$PWD
    python train_deepsea.py --sigma 1.0 --heads 1 --out-size 64 --hidden-layer --position-encoding gaussian --weight-decay 1e-06 --position-sigma 0.1 --outdir ../logs_deepsea --max-iter 30 --filter-size 16 --hidden-size 1536
    ```

* Testing
    ```bash
    python eval_deepsea.py --sigma 1.0 --heads 1 --out-size 64 --hidden-layer --position-encoding gaussian --weight-decay 1e-06 --position-sigma 0.1 --outdir ../logs_deepsea --max-iter 30 --filter-size 16 --hidden-size 1536
    ```
