# Augmented Unlearnable Examples (AUE) & Augmented Adversarial Poisoning (AAP)
This project contains the official Pytorch implementation of paper "Availability Attacks Need to Create Shortcuts for Contrastive Learning", which is under review for ICLR 2024.



## Setup

- Install dependencies:

Modify the last line ```prefix: /data/XXX/anaconda3/envs/aue-aap``` in aue-app-env.yml and run
```angular2html
conda env create -f aue-aap-env.yml
```

## AUE Generation
For CIFAR-10, run
```angular2html
python aue.py \
    --dataset cifar10 \
    --data data/CIFAR10 \
    --backbone resnet18 \
    --eps 8 \
    --mode constant \
    --strength 0.6 \
    --gpu-id 0
```

For CIFAR-100, run
```angular2html
python aue.py \
    --dataset cifar100 \
    --data data/CIFAR100 \
    --backbone resnet18 \
    --eps 8 \
    --mode constant \
    --strength 1 \
    --gpu-id 0
```

## AAP Generation
For CIFAR-10, run
```angular2html
python aap.py \
    --dataset cifar10 \
    --data data/CIFAR10 \
    --backbone resnet18 \
    --eps 8 \
    --ref-mode augmented \
    --gen-mode augmented \
    --ref-strength 0.4 \
    --gen-strength 0.4 \
    --gpu-id 0
```

For CIFAR-100, run
```angular2html
python aap.py \
    --dataset cifar100 \
    --data data/CIFAR100 \
    --backbone resnet18 \
    --eps 8 \
    --ref-mode augmented \
    --gen-mode augmented \
    --ref-strength 0.8 \
    --gen-strength 0.8 \
    --gpu-id 0
```
## Evaluation
This code supports a standard supervised learning algorithm and four contrastive learning algorithms including SimCLR, BYOL, MoCo v2 and SimSiam.

When evaluating the attack performance of a pretrained poison, specify the flag ```--poison-path <.../poison.pt>```.
When training baseline models, delete the flag ```--poison-path```.
- Supervised learning
```angular2html
python evaluation_sl.py \
    --experiment poison_name \
    --poison-path  <.../poison.pt> \
    --dataset cifar10 \
    --data data/CIFAR10 \
    --backbone resnet18 \
    --gpu-id 0
```
- Contrastive learning
```angular2html
python evaluation_cl.py \
    --experiment poison_name \
    --method [SimCLR/MoCo/BYOL/SimSiam] \
    --poison-path  <.../poison.pt> \
    --dataset cifar10 \
    --data data/CIFAR10 \
    --backbone resnet18 \
    --gpu-id 0
```
