# Polyatomic Complexes

This repository is the official implementation of Polyatomic Complexes. 

# Setup

1. Ensure you have python >= 3.11.6 and set up a virtual environment:

```setup
pip install virtualenv
virtualenv .env
source .env/bin/activate
```

2. Install the relevant packages/requirements depending on your desired level of use:

For standard/minimal usage:
```setup
pip install -Ur requirements.txt
```

For graph based experiments:
```setup
pip install -Ur requirements_graph.txt
```

For materials based experiments:
```setup
pip install -Ur requirements_mat.txt
```

3. Download all data from the Zenodo link, unzip the file, and add it to the project in a folder called "dataset"

link: https://zenodo.org/doi/10.5281/zenodo.11049544

The directory structure for dataset should be as follows:
dataset
├── construct
│   ├── atom_lookup.pkl
│   └── lookup_map.json
├── esol
│   ├── ESOL.csv
│   ├── deep_complex_lookup_repn.pkl
│   ├── fast_complex_lookup_repn.pkl
│   └── stacked_complex_lookup_repn.pkl
├── free_solv
│   ├── FreeSolv.csv
│   ├── deep_complex_lookup_repn.pkl
│   ├── fast_complex_lookup_repn.pkl
│   └── stacked_complex_lookup_repn.pkl
├── lipophilicity
│   ├── Lipophilicity.csv
│   ├── deep_complex_lookup_repn.pkl
│   ├── fast_complex_lookup_repn.pkl
│   └── stacked_complex_lookup_repn.pkl
├── materials_project
│   ├── fast_complex_lookup_repn.pkl
│   └── materials_data.csv
├── mp_matbench_jdft2d
│   ├── deep_complex_lookup_repn.pkl
│   ├── fast_complex_lookup_repn.pkl
│   ├── jdft2d.csv
│   ├── matbench_jdft2d.json
│   └── stacked_complex_lookup_repn.pkl
└── photoswitches
    ├── deep_complex_lookup_repn.pkl
    ├── fast_complex_lookup_repn.pkl
    ├── photoswitches.csv
    └── stacked_complex_lookup_repn.pkl


Note that dataset should be on the same level as:
.
├── dataset
├── experiments
├── results
├── src
├── tests
├── requirements_graph.txt
├── requirements_mat.txt
├── requirements.txt
├── LICENSE
├── README.md


## Experiment

To run any experiment reported in the paper complete the following steps in order:

1. Navigate to the experiments folder
2. Choose an benchmark you would like to run by navigating to the appropriate file named: `<benchmark name>_experiment.py`
3. Change the global variable `ENCODING` and set it to the representation you would like to test
4. Save your changes and run python -u `<benchmark name>_experiment.py` or click the run button in your editor


## Results

All results will be saved to a corresponding folder at the path `results/<benchmark name>/<encoding>_<timestamp>.txt` which can later be moved to folders for better organization.

## Licence

MIT License