import pathlib

import pkg_resources
from setuptools import find_packages, setup

with pathlib.Path("requirements.txt").open() as requirements_txt:
    install_requires = [
        str(requirement)
        for requirement in pkg_resources.parse_requirements(requirements_txt)
    ]

# with open("README.md", "r", encoding="utf-8") as fh:
#    long_description = fh.read()

setup(
    name="Robust_RL",
    version="0.0.1",
    author="",
    author_email="",
    description="Robust RL with a Distributional Risk averse formulation",
    # long_description=long_description,
    # long_description_content_type="text/markdown",
    url="",
    project_urls={"Bug Tracker": ""},
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        "cloudpickle==1.6.0",
        # "gym==0.19.0",
        # "gym_donkeycar==1.0.13",
        "highway_env==1.5",
        "matplotlib==3.3.4",
        "moviepy==1.0.3",
        # "mujoco_py==2.1.2.14",
        "numpy==1.20.1",
        "opencv_python==4.5.5.62",
        "optuna==2.10.0",
        "panda_gym==2.0.1",
        "pandas==1.3.3",
        "psutil==5.9.0",
        "pytablewriter==0.64.1",
        "pytest==7.1.2",
        "PyYAML==6.0",
        "rliable==1.0.5",
        "scipy==1.7.3",
        "seaborn==0.11.2",
        "setuptools==58.0.4",
        "sphinxcontrib_programoutput==0.17",
        "tensorboard==2.7.0",
        "torch==1.10.0",
        "tqdm==4.62.3",
    ],
    python_requires=">=3.6",
)
