#!/bin/bash

if [[ -d iclr_addendum ]]; then {
    rm -Rf iclr_addendum
} fi

mkdir iclr_addendum
rsync -av ./ iclr_addendum/texrel/ \
    --exclude .git \
    --exclude iclr_addendum \
    --exclude __pycache__ \
    --exclude '*.egg-info' \
    --exclude .mypy_cache \
    --exclude .push_excludes.txt \
    --exclude .python-version \
    --exclude .pytest_cache \
    --exclude logs \
    --exclude .vscode

mkdir iclr_addendum/lsl
rsync -av ../lsl/shapeworld iclr_addendum/lsl/shapeworld/ \
    --exclude .git \
    --exclude __pycache__ \
    --exclude '*.egg-info' \
    --exclude .mypy_cache \
    --exclude .push_excludes.txt \
    --exclude .python-version \
    --exclude .pytest_cache \
    --exclude logs \
    --exclude .vscode

(
cd iclr_addendum
zip -r iclr_addendum.zip *
unzip -l iclr_addendum.zip
)

