import pytest
from ulfs import formatting


@pytest.mark.parametrize(
    'mean,err,sds,show_err,expected',
    [
        (12.345, 0.123, 2, True, '12.35+/-0.12'),
        (12.345, 0.023, 2, True, '12.345+/-0.023'),
        (12.345, 0.003, 2, True, '12.345+/-0.003'),
        (12.345, 1.234, 2, True, '12.3+/-1.2'),
        (123.456, 12.345, 2, True, '123+/-12'),
        (1234.567, 12.345, 2, True, '1235+/-12'),
        (1234.567, 123.456, 2, True, '1230+/-120'),
        (12.345, 0.000, 2, True, '12.345+/-0.000'),
        (12, 0, 2, True, '12+/-0'),
        (1234, 12, 2, True, '1234+/-12'),
        (1234, 123, 2, True, '1230+/-120'),
        (12345, 1234, 2, True, '12300+/-1200'),

        (12.345, 0.123, 1, True, '12.3+/-0.1'),
        (12.345, 0.023, 1, True, '12.35+/-0.02'),
        (12.345, 0.003, 1, True, '12.345+/-0.003'),
        (1234.567, 12.345, 1, True, '1230+/-10'),
        (12, 0, 1, True, '12+/-0'),
        (12345, 1234, 1, True, '12000+/-1000'),

        (12.345, 0.123, 1, False, '12.3'),
        (12.345, 0.023, 1, False, '12.35'),
        (12.345, 0.003, 1, False, '12.345'),
        (1234.567, 12.345, 1, False, '1230'),
        (12, 0, 1, False, '12'),
        (12345, 1234, 1, False, '12000'),
    ]
)
def test_formatting(mean: float, err: float, sds: int, show_err: bool, expected: str):
    res = formatting.mean_err_to_str(mean, err, err_sds=sds, show_err=show_err)
    assert res == expected
