# Package Installation

In order to use this code, the reader need to install the required Python packages,
notably the packages associated with Pysat: https://pysathq.github.io/docs/html/index.html         

# Code organization

The files dtree.py, encoder.py, gen_dt.py and utils.py are used to generate the SAT encoding. 
Notably, gen_dt.py generates a text file from a decision tree, which is learned using the 
DecisionTreeClassifier component of the scikit-learn library. 
dtree.py and utils.py files include different functions used in gen_dt.py. 
As for the encoder.py, it is used to generate a CNF given a tree and an instance, 
as well as the parameters k and epsilon. 

The file UAI_Functions.py includes the code for the GA and GD algorithms, 
as well as the binary search method, along with some helper functions. 

The file my_tree.py is used to compute orthogonal DNFs representing the decision tree and its negation, 
and to generate path-explanations.

The file UAI_2023_example (in .html and .py) is just an example illustrating 
how to use both greedy algorithms and the SAT method.

Note: in the pysat package, the function solve_limited() is used to interrupt the execution 
of the solver. 

