import os
import pickle
import argparse
import numpy as np

parser = argparse.ArgumentParser()
parser.add_argument('--data_dir', type=str, default='data')
parser.add_argument('--data_name',type=str, default='saved_data_True_True_True.pkl')
parser.add_argument('--dataset', type=str, default='humanact12')
parser.add_argument('--concept_name', type=str, default='walk')

args = parser.parse_args()

humanact12_limbs = [(0, 1), (1, 4), (4, 7), (7, 10), (0, 2), (2, 5), (5, 8), (8, 11), (0, 3), (3, 6), (6, 9), \
                    (9, 12), (12, 15), (9, 13), (13, 16), (16, 18), (18, 20), (20, 22), (9, 14), (14, 17), (17, 19), (19, 21), (21, 23)]

def main(args):
    data_dir = os.path.join(args.data_dir, args.dataset, args.concept_name)
    with open(os.path.join(data_dir, args.data_name), 'rb') as f:
        saved_data = pickle.load(f)
    keypoint_sequences = saved_data['rotated_keypoint_sequence']
    anchor_pos_labels = saved_data['anchor_pos_label']
    anchor = []
    for i in range(len(keypoint_sequences)):
        anchor_pos_label = anchor_pos_labels[i]
        anchor_pos = np.where(anchor_pos_label == 1)[0]
        keypoint_sequence = keypoint_sequences[i]
        for j in range(len(anchor_pos)):
            anchor.append(keypoint_sequence[anchor_pos[j]])
    anchor = np.array(anchor)
    np.save(os.path.join(data_dir, 'rotated_anchor_data_random.npy'), anchor)
    print("anchor:", anchor.shape)


if __name__ == '__main__':
    main(args)
