import os
import pickle
import argparse
import numpy as np
import scipy.stats as stats


def mean_confidence_interval(data, confidence=0.95):
    a = 1.0 * np.array(data)
    n = len(a)
    m, se = np.mean(a), stats.sem(a)
    h = se * stats.t.ppf((1 + confidence) / 2., n-1)
    return m, h

parser = argparse.ArgumentParser()
parser.add_argument('-sd', '--source_dir', type=str, default="saved_models_best")
parser.add_argument('-ut', '--unsuitable_type', type=str, default="all")
parser.add_argument('-d', '--dataset', type=str, default="humanact12")
parser.add_argument('--concept_list', nargs="+")
# parser.add_argument('--concept_list', type=int, nargs="+")
parser.add_argument('-mn', '--model_name', type=str, default="action2motion")
parser.add_argument('--experiment_name', type=str, default='test')
parser.add_argument('--num_samples', type=int, default=20)
parser.add_argument('--split', type=str, default='test')
parser.add_argument('--eval_full', action='store_true')

args = parser.parse_args()

humanact12_match = {
    "0": "warm_up",
    "1": "walk",
    "2": "run",
    "3": "jump",
    "4": "drink",
    "5": "lift_dumbbell",
    "6": "sit",
    "7": "eat",
    "8": "turn_steer_wheel",
    "9": "phone",
    "10": "boxing",
    "11": "throw"
}

def main(args):
    if not args.eval_full:
        for concept in args.concept_list:
            model_names = ["action2motion", "actor"]
            model_results = {}
            for model_name in model_names:
                if args.dataset == "uestc":
                    splits = ["train", "test"]
                    uestc_results = {}
                    for split in splits:
                        split_results = {}
                        unsuitable_types = ["one", "arn"]
                        for unsuitable_type in unsuitable_types:
                            split_results[unsuitable_type] = {}
                            results_dir = os.path.join(args.source_dir, args.dataset, concept, args.experiment_name, args.dataset, unsuitable_type, model_name, split)
                            split_results[unsuitable_type]["gt_accuracy"] = []
                            split_results[unsuitable_type]["gt_diversity"] = []
                            split_results[unsuitable_type]["gt_multimodality"] = []
                            split_results[unsuitable_type]["gen_accuracy"] = []
                            split_results[unsuitable_type]["gen_diversity"] = []
                            split_results[unsuitable_type]["gen_multimodality"] = []
                            split_results[unsuitable_type]["refined_anchor_accuracy"] = []
                            split_results[unsuitable_type]["refined_anchor_diversity"] = []
                            split_results[unsuitable_type]["refined_anchor_multimodality"] = []
                            split_results[unsuitable_type]["refined_accuracy"] = []
                            split_results[unsuitable_type]["refined_diversity"] = []
                            split_results[unsuitable_type]["refined_multimodality"] = []
                            split_results[unsuitable_type]["gen_fid"] = []
                            split_results[unsuitable_type]["refined_anchor_fid"] = []
                            split_results[unsuitable_type]["refined_fid"] = []
                            for i in range(args.num_samples):
                                with open(os.path.join(results_dir, str(i), f"evaluation_results.pkl"), 'rb') as f:
                                    results = pickle.load(f)
                                split_results[unsuitable_type]["gt_accuracy"].append(results['gt_accuracy']*100)
                                split_results[unsuitable_type]["gt_diversity"].append(results['gt_diversity'])
                                split_results[unsuitable_type]["gt_multimodality"].append(results['gt_multimodality']*30)
                                split_results[unsuitable_type]["gen_accuracy"].append(results['generated_accuracy']*100)
                                split_results[unsuitable_type]["gen_diversity"].append(results['generated_diversity'])
                                split_results[unsuitable_type]["gen_multimodality"].append(results['generated_multimodality']*30)
                                split_results[unsuitable_type]["refined_accuracy"].append(results['refined_accuracy']*100)
                                split_results[unsuitable_type]["refined_diversity"].append(results['refined_diversity'])
                                split_results[unsuitable_type]["refined_multimodality"].append(results['refined_multimodality']*30)
                                split_results[unsuitable_type]["refined_anchor_accuracy"].append(results['refined_anchor_accuracy']*100)
                                split_results[unsuitable_type]["refined_anchor_diversity"].append(results['refined_anchor_diversity'])
                                split_results[unsuitable_type]["refined_anchor_multimodality"].append(results['refined_anchor_multimodality']*30)
                                split_results[unsuitable_type]["gen_fid"].append(results['fid_generated'])
                                split_results[unsuitable_type]["refined_anchor_fid"].append(results['fid_refined_anchor'])
                                split_results[unsuitable_type]["refined_fid"].append(results['fid_refined'])
                        uestc_results[split] = split_results
                    model_results[model_name] = uestc_results
            print(f"==> Concept: {concept}")
            print("----------FID----------")
            # 保留两位小数
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_fid"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_fid"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_fid"])[1]))
            print("----------Diversity----------")
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_diversity"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_diversity"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_diversity"])[1]))
            print("----------Multimodality----------")
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_multimodality"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_multimodality"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_multimodality"])[1]))
            print("----------Accuracy----------")
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gt_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gt_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["gen_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["gen_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gt_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gt_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["gen_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["gen_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["one"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["one"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["train"]["arn"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["action2motion"]["test"]["arn"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["one"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["one"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["train"]["arn"]["refined_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_anchor_accuracy"])[1]))
            print("{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_accuracy"])[0]), "\\textsuperscript{$\pm$}", "{:.2f}".format(mean_confidence_interval(model_results["actor"]["test"]["arn"]["refined_accuracy"])[1]))
            

if __name__ == "__main__":
    main(args)

