# Refine Synthesized 3D Human Motion with Unsupervised Learned Motion Concepts

This repository contains the implementation of:

**Refine Synthesized 3D Human Motion with Unsupervised
Learned Motion Concepts**

## Environment
The codes in this folder are developed with PyTorch and CUDA support.

## Data preprocess

The data segmentation codes are in folder ``motion2prog``. Use the following command to process the data

``python fit_humanact12.py``

or

``python fit_uestc.py``

## Anchor Clustering

The anchor clustering codes are in folder ``anchor_cluster``. Use the following command to perform anchor clustering

``python anchor_cluster.py -n <CLUSTER_NUM> --concept_list <ACTION_IDX or ACTION_NAME>``

where ``<CLUSTER_NUM>`` denotes the number of classes.

## Training

To train a motion refinement model for an action, use the following command

``python main.py -o 0 1 2 4 5 7 8 --dataset <DATASET_NAME> --concept_list <ACTION_IDX or ACTION_NAME>``

For HumanAct12, the input of concept_list is the index of the 12 actions. For UESTC, the input of concept_list is the name of the action.

## Evaluation

To evaluate the motion refinement model for an action on a specific baseline, use the command 

For HumanAct12

``python main.py -o 9 --dataset humanact12 --concept_list <ACTION_IDX> --model_name <BASELINE>``

For UESTC

``python main.py -o 11 --dataset uestc --concept_list <ACTION_NAME> --model_name <BASELINE>``

where ``<BASELINE>`` is the name of the baseline like action2motion, actor and motiongpt.
