import numpy as np
from model.msg3dutils import tools


n_node = 24
self_link = [(i, i) for i in range(n_node)]
inward = [(0, 1), (1, 4), (4, 7), (7, 10), (0, 2), (2, 5), (5, 8), (8, 11), (0, 3), (3, 6), (6, 9), \
        (9, 12), (12, 15), (9, 13), (13, 16), (16, 18), (18, 20), (20, 22), (9, 14), (14, 17), (17, 19), (19, 21), (21, 23)]
outward = [(j, i) for (i, j) in inward]
neighbor = inward + outward


class HumanAct12Graph:
    def __init__(self):
        self.edges = neighbor
        self.n_node = n_node
        self.self_link = self_link
        self.inward = inward
        self.outward = outward
        self.neighbor = neighbor
        self.A_binary = tools.get_adjacency_matrix(self.edges, self.n_node)
        self.A_binary_with_I = tools.get_adjacency_matrix(self.edges + self.self_link, self.n_node)
        self.A = tools.normalize_adjacency_matrix(self.A_binary)


if __name__ == '__main__':
    import matplotlib.pyplot as plt
    graph = HumanAct12Graph()
    A, A_binary, A_binary_with_I = graph.A, graph.A_binary, graph.A_binary_with_I
    f, ax = plt.subplots(1, 3)
    ax[0].imshow(A_binary_with_I, cmap='gray')
    ax[1].imshow(A_binary, cmap='gray')
    ax[2].imshow(A, cmap='gray')
    plt.show()
    print(A_binary_with_I.shape, A_binary.shape, A.shape)
