import os
import subprocess

root_directory = os.path.join('uestc')
program_path = os.path.join('fit.py')

action_list = sorted(os.listdir(root_directory))

for folder_name in action_list:
    concept_path = os.path.join(root_directory, folder_name)
    if os.path.isdir(concept_path):
        for instance_name in os.listdir(concept_path):
            save_path = os.path.join("visualization", "static", "uestc", folder_name, instance_name)
            if os.path.exists(save_path):
                continue
            instance_path = os.path.join(concept_path, instance_name)
            if os.path.isdir(instance_path):
                command = [
                    "python",
                    program_path,
                    "-d",
                    instance_path,
                    "-k",
                    "uestc",
                    "-a",
                    "-x",
                    "-c",
                    "-p",
                    "2",
                    "-w",
                    "20",
                    "--no-acc",
                    "--stat-thres",
                    "5",
                    "--span-thres",
                    "5",
                    "--cores",
                    "9",
                    "-r",
                    "200",
                    "-o",
                    save_path
                ]
                
                subprocess.run(command)