import torch
import torch.nn as nn


class AnchorClassifier(nn.Module):
    def __init__(self, args):
        super(AnchorClassifier, self).__init__()
        self.args = args
        self.num_joints = args.num_joints
        self.n_cluster = args.n_clusters
        self.fc1 = nn.Linear(args.num_joints*3, 128)
        self.fc2 = nn.Linear(128, 256)
        self.fc3 = nn.Linear(256, 128)
        self.fc4 = nn.Linear(128, self.n_cluster)

    def forward(self, x):
        x = torch.relu(self.fc1(x))
        x = torch.relu(self.fc2(x))
        x = torch.relu(self.fc3(x))
        x = torch.softmax(self.fc4(x), dim=1)
        return x
