import numpy as np
from scipy.optimize import curve_fit, minimize, least_squares
import matplotlib.pyplot as plt
import matplotlib.colors as colors
import matplotlib.cm as cmx

ARGS = {}
synt_args = {}

## Colors for quick use
# (B, G, R) format for OpenCV
WHITE = (255, 255, 255)
BLACK = (0, 0, 0)
GREY = (192, 192, 192)
DGREY = (70, 70, 70)
ORANGE = (20, 72, 221)
GREEN = (143, 223, 4)
BLUE = (255, 144, 30)
DPINK = (84, 4, 223)
# (R, G, B) format colors
R_ORANGE = (221, 72, 20)
R_GREEN = (4, 223, 143)
R_BLUE = (30, 144, 255)
R_DPINK = (223, 4, 84)

# MPII 15 joints
mpii_joints = list(range(15))
mpii_limbs = [(0, 1), (1, 2), (2, 3), (3, 4), (5, 1), (6, 5), (7, 6), \
            (1, 8), (8, 9), (9, 10), (10, 11), (8, 12), (12, 13), (13, 14)]

# PoseWarp 14 joints
posewarp_joints = [0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14]
posewarp_limbs = [(0, 1), (1, 2), (2, 3), (3, 4), (5, 1), (6, 5), (7, 6), \
            (1, 9), (9, 10), (10, 11), (1, 12), (12, 13), (13, 14)]

# COCO 18 joints
coco_joints = list(range(18))
coco_limbs = [[1, 2], [1, 5], [2, 3], [3, 4], [5, 6], [6, 7], [1, 8], [8, 9], \
		   [9, 10], [1, 11], [11, 12], [12, 13], [1, 0], [0, 14], [14, 16], \
		   [0, 15], [15, 17]] 

# Human3.6m 17 joints
human36m_joints = list(range(17))
human36m_limbs = [(0, 1), (1, 2), (2, 3), (0, 4), (4, 5), (5, 6), (0, 7), \
            (7, 8), (8, 9), (9, 10), (8, 11), (11, 12), (12, 13), (8, 14), (14, 15), (15, 16)]

# NTU 25 joints
ntu_joints = list(range(25))
ntu_limbs = [(0, 1), (1, 20), (2, 20), (3, 2), (4, 20), (5, 4), (6, 5), (7, 6), (8, 20), (9, 8), \
            (10, 9), (11, 10), (12, 0), (13, 12), (14, 13), (15, 14), (16, 0), (17, 16), (18, 17), (19, 18), (21, 22), (22, 7), (23, 24), (24, 11)]

# HumanAct12 24 joints
humanact12_joints = list(range(24))
humanact12_limbs = [(0, 1), (1, 4), (4, 7), (7, 10), (0, 2), (2, 5), (5, 8), (8, 11), (0, 3), (3, 6), (6, 9), \
                    (9, 12), (12, 15), (9, 13), (13, 16), (16, 18), (18, 20), (20, 22), (9, 14), (14, 17), (17, 19), (19, 21), (21, 23)]

# UESTC 18 joints
uestc_joints = list(range(18))
uestc_limbs = [(0, 1), (0, 9), (9, 10), (10, 11), (11, 16), (0, 12), (12, 13), (13, 14), (14, 15), (1, 2), (2, 3), (3, 4), (1, 5), (5, 6), (6, 7), (1, 8), (8, 17)]

H = None
W = None
filename = None
center = None
scale = None
scale_factor = 1.14
