# Readme

Supplementary material for submission "HAIDNet: Encoding Human Behavior in Automated Information Design", including simulation and human-subject experiment data and codes.

## Simulation codes 

```Single_receiver_2action.py``` is for simulation in one receiver, M states and binary actions case. 
```
python Single_receiver_2action.py 10
```

```Single_receiver_naction.py``` is for simulation in one receiver, M states and N actions case. 
```
python Single_receiver_naction.py 10 5
```

```Non_bayesian_rational_receiver.py``` is for simulation in one receiver, binary actions and binary states case. Receiver is supposed to be non-Bayesian rational, controled by parameters $\alpha, \beta_H, \gamma$. In simulations, we only change value of $\beta_H$ and keep $\alpha=1.0, \gamma=0.0$.
```
python Non-bayesian-rational-exp.py 1.0 10.0 0.0
```

```Public_persuasion.py``` is for simulation in K receivers, binary actions and binary states case.
```
python Public_persuasion.py 10
```

### Imported files
```Datagene.py``` defines functions used to generate datasets. Currently we use ```getXY_human_model_exp``` to generate data. 
```Human_Model.py``` defines receiver model and corresponding HAIDNet model. ```HumanDecisionMakerModel``` is a rpe-defined model, controled by 'alpha, beta, gamma'; ```HumanDecisionMakerNN``` is neural network trained with human response; ```PolicyNeuralNetwork``` is policy neural network when loss is calculated by human response from a pre-defined model or NN model. 
```Policy_module.py``` is the HAIDNet model when receiver are Bayesian rational.


## Human subject experiments

We recruit 300 individual workers from Amazon Mechanical Turk. Experiment data is stored in `human-subject-experiments/First_experiment.csv` and `Second_experiment.csv`:

-   `uid` represents anonymous workers, from 0 to 100 in first experiment and 0 to 200 in second experiment
-   `treatment` treatment of the worker, from 0-3 (0:random policy, 1:BR-policy, 2:TH-policy, 3:HAIDNet policy)
-   `question_idx` test order of questions, from 0 to 19 
-   `Ur` utility of receiver, from 0 to 5
-   `information_policy` information policy, the conditional probability of generating signals given true state of the product 
-   `select_state` true state of the product selected during experiments (0: good product, 1: bad product)
-   `select_signal` the singal shown to parcipants when making a decision (0: good signal, 1: bad signal)
-   `user_choice` parcipants' decision in the specific question (0: don't buy, 1: buy)

Experiment interface is shown in the Appendix.
