# Run parallel evaluations for all datasets and methods
echo "Running parallel evaluations for all datasets and methods..."

# Create arrays of datasets and methods
datasets=(
    "clutrr" "clevr" "leaf" "omnimath-1" "bbeh_word_sorting" "bbeh_dyck_languages"
    "bbeh_object_counting" "bbeh_object_properties" "bbeh_boardgame_qa" "bbeh_boolean_expressions"
    "bbeh_zebra_puzzles" "bbeh_buggy_tables" "bbeh_spatial_reasoning" "bbeh_multistep_arithmetic"
    "bbeh_geometric_shapes" "bbeh_shuffled_objects" "bbeh_temporal_sequence" "bbeh_disambiguation_qa"
    "bbeh_causal_understanding" "bbeh_time_arithmetic" "bbeh_web_of_lies" "bbeh_sarc_triples"
    "bbeh_nycc" "bbeh_sportqa" "bbeh_linguini" "bbeh_movie_recommendation"
)
# methods=("code" "gen_sym_reason_prog" "gen_sym_reason_prog_checks")
methods=("code")

# Function to wait if we have too many background jobs
wait_if_needed() {
    while [ $(jobs -p | wc -l) -ge 32 ]; do
        sleep 1
    done
}

# # Conditionally run run_experiments.py based on log file existence
# echo "Conditionally running run_experiments.py..."
# for dataset in "${datasets[@]}"; do
#     log_file="logs/gemini-2.0-flash/${dataset}/zs_cot/outputs_gen_1_temp_0.0.txt"
#     if [ ! -f "$log_file" ]; then
#         echo "Log file $log_file does not exist."
#         wait_if_needed
#         python scripts/run_experiments.py --model "gemini-2.0-flash" --method zs_cot --dataset "$dataset" &
#     else
#         echo "Log file $log_file exists. Skipping run_experiments.py for dataset $dataset."
#     fi
# done

# # Wait for all conditional background jobs to complete
# wait


# echo "Conditionally running algorithmic_eval.py..."
# for dataset in "${datasets[@]}"; do
#     # Check for method 1
#     result_file_1="logs/gemini-2.0-flash/${dataset}/algorithmic_eval_results_1.json"
#     if [ ! -f "$result_file_1" ]; then
#         wait_if_needed
#         echo "Result file $result_file_1 not found. Running algorithmic_eval.py (method 1) for dataset $dataset..."
#         python scripts/algorithmic_eval.py --model gemini-2.0-flash --method 1 --dataset "$dataset" &
#     else
#         echo "Result file $result_file_1 found. Skipping algorithmic_eval.py (method 1) for dataset $dataset."
#     fi

#     # Check for method 2
#     result_file_2="logs/gemini-2.0-flash/${dataset}/algorithmic_eval_results_2.json"
#     if [ ! -f "$result_file_2" ]; then
#         wait_if_needed
#         echo "Result file $result_file_2 not found. Running algorithmic_eval.py (method 2) for dataset $dataset..."
#         python scripts/algorithmic_eval.py --model gemini-2.0-flash --method 2 --dataset "$dataset" &
#     else
#         echo "Result file $result_file_2 found. Skipping algorithmic_eval.py (method 2) for dataset $dataset."
#     fi
# done

# # Wait for all background jobs to complete
# wait

for method in "${methods[@]}"; do
    for dataset in "${datasets[@]}"; do
        # if [ ! -f "logs/gemini-2.0-flash/${dataset}/${method}/code_eval_results.json" ]; then
        #     echo "Result file for $dataset with method $method not found. Running code_eval.py..."
        #     wait_if_needed
        #     python scripts/code_eval.py --model gemini-2.0-flash --method "$method" --dataset "$dataset" &
        # else
        #     echo "Result file for $dataset with method $method found. Skipping code_eval.py."
        # fi

        # Check if the JSON file has the expected content (200 lines)
        if [ -f "logs/gemini-2.0-flash/${dataset}/${method}/code_eval_results.json" ]; then
            line_count=$(grep -o '"index"' "logs/gemini-2.0-flash/${dataset}/${method}/code_eval_results.json" 2>/dev/null | wc -l)
            if [ -z "$line_count" ] || [ "$line_count" -lt 200 ]; then
            echo "Result file for $dataset with method $method exists but has $line_count lines instead of 200. Re-running code_eval.py..."
            wait_if_needed
            python scripts/code_eval.py --model gemini-2.0-flash --method "$method" --dataset "$dataset" &
            fi
        fi
    done
done

wait

# for method in "${methods[@]}"; do
#     for dataset in "${datasets[@]}"; do
#         wait_if_needed
#         echo "Running eval for dataset $dataset with method $method..."
#         python scripts/run_experiments.py --model gemini-2.0-flash --method "$method" --dataset "$dataset" --eval &
#     done
# done

# wait

echo "All evaluations complete."

