All of the experiments where run on GPU, so in order to reproduce them please use a gpu, as there might be unexpected behavior with different hardware

# Reproducing Continual Learning Experiments

## MNIST

### SGD:
` python main.py -cf="configs/mnist_sgd_continual.yml" `

### SIOPT:
` python main.py -cf="configs/mnist_siopt_continual.yml" `

## FashionMNIST

### SGD:
` python main.py -cf="configs/fashion_mnist_sgd_continual.yml" `

### SIOPT:
` python main.py -cf="configs/fashion_mnist_siopt_continual.yml" `

## CIFAR10

### SGD:
` python main.py -cf="configs/sgd_linear_cifar10/cifar10_sgd_seed1.yml" `

### SIOPT:
` python main.py -cf="configs/siopt_linear_cifar10/cifar10_siopt_seed1.yml" `

## CIFAR100

### SGD:
` python main.py -cf="configs/sgd_linear_cifar100/cifar100_sgd_seed1.yml" `

### SIOPT:
` python main.py -cf="configs/siopt_linear_cifar100/cifar100_siopt_seed1.yml" `

# Reproducing Unlearning

## MNIST

### SGD

First you need to run the command

`python main.py -cf="configs/mnist_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/mnist_sgd_forgetting.yml"`

to do the unlearning.

### SIOPT

First you need to run the command

`python main.py -cf="configs/mnist_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/mnist_siopt_forgetting.yml"`

to do the unlearning.

## FashionMNIST

### SGD

First you need to run the command

`python main.py -cf="configs/fashion_mnist_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/fashion_mnist_sgd_forgetting.yml"`

to do the unlearning.

### SIOPT

First you need to run the command

`python main.py -cf="configs/fashion_mnist_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/fashion_mnist_siopt_forgetting.yml"`

to do the unlearning.

## CIFAR10

### SGD

First you need to run the command

`python main.py -cf="configs/cifar10_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/cifar10_sgd_forgetting.yml"`

to do the unlearning.

### SIOPT

First you need to run the command

`python main.py -cf="configs/cifar10_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/cifar10_siopt_forgetting.yml"`

to do the unlearning.

## CIFAR100

### SGD

First you need to run the command

`python main.py -cf="configs/cifar100_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/cifar100_sgd_forgetting.yml"`

to do the unlearning.

### SIOPT

First you need to run the command

`python main.py -cf="configs/cifar100_sgd_standard.yml"`

to get the trained model across the whole dataset and then you should run the command

`python main.py -cf="configs/cifar100_siopt_forgetting.yml"`

to do the unlearning.

# Reproducibility statement

We run three random seeds with each command above. You can do this by changing the `seed` parameter in the corresponding yaml config.

## Plotting

Use the `plotting.ipynb` corresponding section to do your plots.