#!/usr/bin/env python
# ========================= #
# Training of network model #
# ========================= #

# Usage: python <path-to-this-file>/train.py <your_config>.ini [-n NUM_THREADS]


import os
import argparse

parser = argparse.ArgumentParser(description='Train TraceGradH: a SO(3)-equivariant Non-linear Representation Learning Method for Hamiltonian Regression in Crystalline Material Research')
parser.add_argument('config', type=str, metavar='CONFIG', help='Config file for training')
parser.add_argument('-n', type=int, default=None, help='Maximum number of threads')
args = parser.parse_args()

if args.n is not None:
    os.environ["OMP_NUM_THREADS"] = f"{args.n}"
    os.environ["MKL_NUM_THREADS"] = f"{args.n}"
    os.environ["NUMEXPR_NUM_THREADS"] = f"{args.n}"
    os.environ["OPENBLAS_NUM_THREADS"] = f"{args.n}"
    os.environ["VECLIB_MAXIMUM_THREADS"] = f"{args.n}"
    import torch
    torch.set_num_threads(args.n)

from src import TraceGradHKernel
kernel = TraceGradHKernel()
kernel.train(args.config)
