# A Framework of SO(3)-equivariant Non-linear Representation Learning and its Application to Electronic-Structure Hamiltonian Prediction

## Overview
This is the README file for training and testing of our work entitled 'A Framework of SO(3)-equivariant Non-linear Representation Learning and its Application to Electronic-Structure Hamiltonian Prediction'. The software package for this work is called as 'TraceGrad', which is an abbreviation of the core of our method. PLEASE read this file with a reader or editor with a Markdown render.

## System Requirements
The experiments for 'TraceGrad' are conducted on a Tesla A100 GPU cluster. Each GPU card in the cluster has 80 GiB of memory. The software environment required is outlined below:

- Python Version: 3.11.4
- torch Version: 2.0.1+cu117
- tqdm Version: 4.66.1
- pymatgen Version: 2023.8.10
- torch_geometric Version: 2.3.1
- pathos Version: 0.3.1
- h5py Version: 3.9.0
- e3nn Version: 0.4.4
- tensorboard Version: 2.15.1

## Dataset Preparation
Experiments are conducted on six crystalline material databases released by the DeepH series [1,2]. These databases include:

1. Monolayer Graphene (MG)
2. Monolayer MoS2 (MM)
3. Bilayer Graphene (BG)
4. Bilayer Bismuthene (BB)
5. Bilayer Bi2Te3 (BT)
6. Bilayer Bi2Se3 (BS)

Create a `data` folder in your working directory to store these datasets. The download links and instructions for each dataset are as follows:

- MG Dataset: [Download here](https://zenodo.org/records/7553640/files/Monolayer_graphene_dataset.zip?download=1). Unzip as `/your_path/data/Monolayer_graphene_dataset`.
- MM Dataset: [Download here](https://zenodo.org/records/7553640/files/Monolayer_MoS2_dataset.zip?download=1). Unzip as `/your_path/data/Monolayer_MoS2_dataset`.
- BG Dataset: 
  - Non-twisted samples: [Download here](https://zenodo.org/records/7553640/files/Bilayer_graphene_dataset.zip?download=1). Unzip as `/your_path/data/Bilayer_graphene_dataset`.
  - Twisted subset: [Download here](https://zenodo.org/records/7553640/files/Bilayer_graphene_twisted.zip?download=1). Unzip as `/your_path/data/Bilayer_graphene_twisted`.
- BB Dataset: 
  - Non-twisted samples: [Download here](https://zenodo.org/records/7553640/files/Bismuth_dataset.zip?download=1). Unzip as `/your_path/data/Bilayer_Bismuth_dataset`.
  - Twisted subset: [Download here](https://zenodo.org/records/7553640/files/Bismuth_twisted.zip?download=1). Unzip as `/your_path/data/Bilayer_Bismuth_twisted`.
- BT Dataset: 
  - Non-twisted samples: [Download here](https://zenodo.org/records/7553843/files/Bi2Te3_dataset_soc.zip?download=1). Unzip as `/your_path/data/Bilayer_Bi2Te3_dataset`.
  - Twisted subset: [Download here](https://zenodo.org/records/7553843/files/Bi2Te3_twisted_soc.zip?download=1). Unzip as `/your_path/data/Bilayer_Bi2Te3_twisted`.
- BS Dataset: 
  - Non-twisted samples: Download from four links and unzip all to `/your_path/data/Bilayer_Bi2Se3_dataset`.
    - [Dataset 1](https://zenodo.org/records/7553827/files/Bi2Se3_dataset1.zip?download=1)
    - [Dataset 2](https://zenodo.org/records/7553827/files/Bi2Se3_dataset2.zip?download=1)
    - [Dataset 3](https://zenodo.org/records/7553827/files/Bi2Se3_dataset3.zip?download=1)
    - [Dataset 4](https://zenodo.org/records/7553827/files/Bi2Se3_dataset4.zip?download=1)
  - Twisted subset: [Download here](https://zenodo.org/records/7553827/files/Bi2Se3_twisted.zip?download=1). Unzip as `/your_path/data/Bilayer_Bi2Se3_twisted`.


## Training and Testing Instructions:
These instructions provide a step-by-step guide for training and testing the 'TraceGrad' framework on each of the six datasets. Follow these steps for each dataset:

### MG Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Monolayer_graphene_train_test.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Monolayer_graphene_train_test.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Monolayer_graphene_train_test.ini`, set `is_training` as False, and run the command.


### MM Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Monolayer_MoS2_train_test.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Monolayer_MoS2_train_test.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Monolayer_MoS2_train_test.ini`, set `is_training` as False, and run the command.

### BG Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Bilayer_graphene_train_test.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Bilayer_graphene_train_test.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Bilayer_graphene_train_test.ini`, set `is_training` as False, and run the command.

  ii. **Testing on Twisted Samples**:

      - For testing the trained network on twisted samples, update the `trained_model_dir` in `/your_path/inis/Bilayer_graphene_eval_twist.ini` with the directory of the trained model (found in a subfolder of the `save_dir` from the training phase, containing `.pkl` files and automatically saved src files). Also, update `processed_data_dir`, `save_graph_dir`, and `save_dir`, replacing "/your_path/" with your current directory. Then, run `python3 TraceGradH-evaltwisted.py /your_path/inis/Bilayer_graphene_eval_twist.ini` to get the test results.



### BB Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Bilayer_Bismuth_train_test_soc.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Bilayer_Bismuth_train_test_soc.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Bilayer_Bismuth_train_test_soc.ini`, set `is_training` as False, and run the command.

  ii. **Testing on Twisted Samples**:

      - For testing the trained network on twisted samples, update the `trained_model_dir` in `/your_path/inis/Bilayer_Bismuth_eval_soc_twist.ini` with the directory of the trained model (found in a subfolder of the `save_dir` from the training phase, containing `.pkl` files and automatically saved src files). Also, update `processed_data_dir`, `save_graph_dir`, and `save_dir`, replacing "/your_path/" with your current directory. Then, run `python3 TraceGradH-evaltwisted.py /your_path/inis/Bilayer_Bismuth_eval_soc_twist.ini` to get the test results.

### BT Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Bilayer_Bi2Te3_train_test_soc.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Bilayer_Bi2Te3_train_test_soc.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Bilayer_Bi2Te3_train_test_soc.ini`, set `is_training` as False, and run the command.

  ii. **Testing on Twisted Samples**:

      - For testing the trained network on twisted samples, update the `trained_model_dir` in `/your_path/inis/Bilayer_Bi2Te3_eval_soc_twist.ini` with the directory of the trained model (found in a subfolder of the `save_dir` from the training phase, containing `.pkl` files and automatically saved src files). Also, update `processed_data_dir`, `save_graph_dir`, and `save_dir`, replacing "/your_path/" with your current directory. Then, run `python3 TraceGradH-evaltwisted.py /your_path/inis/Bilayer_Bi2Te3_eval_soc_twist.ini` to get the test results.

### BS Dataset:

  i. **Train and Test**:

     - Update the paths in `/your_path/inis/Bilayer_Bi2Se3_train_test_soc.ini` for `processed_data_dir`, `save_graph_dir`, and `save_dir`. Typically, replace "/your_path/" with your current directory, while keeping the subdirectories as default.

     - Execute the following command: `python3 TraceGradH-train-test.py /your_path/inis/Bilayer_Bi2Se3_train_test_soc.ini`. This trains the network and tests its performance.

     - Note: To test an already trained network, place the path of the trained `.pkl` file in `checkpoint` of `Bilayer_Bi2Se3_train_test_soc.ini`, set `is_training` as False, and run the command.

  ii. **Testing on Twisted Samples**:

      - For testing the trained network on twisted samples, update the `trained_model_dir` in `/your_path/inis/Bilayer_Bi2Se3_eval_soc_twsit.ini` with the directory of the trained model (found in a subfolder of the `save_dir` from the training phase, containing `.pkl` files and automatically saved src files). Also, update `processed_data_dir`, `save_graph_dir`, and `save_dir`, replacing "/your_path/" with your current directory. Then, run `python3 TraceGradH-evaltwisted.py /your_path/inis/Bilayer_Bi2Se3_eval_soc_twsit.ini` to get the test results.



## References
1. Li, H., Wang, Z., Zou, N., Ye, M., Xu, R., Gong, X., Duan, W., and Xu, Y. (2022). Deep-learning density functional theory hamiltonian for efficient ab initio electronic-structure calculation. *Nature Computational Science*, 2(6), 367–377.
2. Gong, X., Li, H., Zou, N., Xu, R., Duan, W., and Xu, Y. (2023). General framework for e(3)-equivariant neural network representation of density functional theory hamiltonian. *Nature Communications*, 14(1), 2848.
