
# Mean Field Theory in Deep Metric Learning


## Requirements

Main requirements:
- Linux
- Python 3.8.13
- powerful-benchmarker==0.9.32
- pytorch-metric-learning==0.9.88

Install necessary libraries:
```bash
pip install -r requirements.txt
```

You also need
- NVIDIA V100 (for MLRC evaluation (all datasets), traditional evaluation (cub&cars))
- NVIDIA A100 (traditional evaluation (sop&inshop))


## Datasets

Download the following datasets:
 - [CUB-200-2011](http://www.vision.caltech.edu/visipedia-data/CUB-200-2011/CUB_200_2011.tgz)
 - Cars-196 ([Img](http://imagenet.stanford.edu/internal/car196/car_ims.tgz), [Annotation](http://imagenet.stanford.edu/internal/car196/cars_annos.mat))
 - Stanford Online Products ([Link](https://cvgl.stanford.edu/projects/lifted_struct/))
 - InShop Clothes Retrieval ([Link](http://mmlab.ie.cuhk.edu.hk/projects/DeepFashion.html))

Place them in `datasets` dir as follows:
```
datasets
├── InShop
│   ├── img
│   └── list_eval_partition.txt
├── Stanford_Online_Products
│   ├── Ebay_final.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
│   └── toaster_final.txt
├── cars196
│   ├── car_ims
│   └── cars_annos.mat
└── cub2011
    ├── CUB_200_2011
    └── attributes.txt
```

## Getting started


```
### CUB
python -m src._train --gpu-id 0 --dataset cub \
                --model bn_inception \
                --bn-freeze 0 \
                --embedding-size 512 \
                --batch-size 128 \
                --loss MeanFieldClassWiseMultiSimilarity \
                --alpha 0.01 --beta 80 --mrg 0.8 --reg 0 --pow 2 --lr-ratio 2000 --seed 0 \
                --warm 1 \
                --lr 1e-4 \
                --weight-decay 1e-4 \
                --lr-decay-step 10 \
                --lr-decay-gamma 0.25 \
                --workers 8 \
                --patience 5
```

## Reproducing evaluation results

### MLRC evaluation

To evaluate our models in the MLRC protocol, run

```bash
sh scripts/mf_cont_l2.sh
sh scripts/mf_cw_ms_l2.sh
```

For MLRC evaluation of baseline models, run `arc.sh, cos.sh, proxy_nca.sh, proxy_anc.sh, cont.sh, ms.sh, ms_w_mn.sh, cw_ms.sh`, instead.

### Traditional evaluation

To evaluate our models in the traditional protocol, run

```bash
sh scripts/eval_all.sh
```

To reproduce results in Sec. 4.4 and the supplement,
```bash
### Embedding dimensions
sh scripts/dim_cub.sh

### Batch size:
sh scripts/batch_small.sh
sh scripts/batch_large.sh

### beta and delta
sh scripts/mfcont_cub.sh

### reg
sh scripts/reg_cub.sh
```
