from __future__ import annotations

from abc import ABC
from abc import abstractmethod
from dataclasses import dataclass
from typing import Any
from typing import Optional


class Bench(ABC):
    """An interface for benchmarks.
    """

    @abstractmethod
    def benchmark(self) -> BenchMeasurement:
        """Run the benchmark and return a `BenchResult`.
        """

        raise NotImplementedError


@dataclass
class BenchMeasurement:
    """Represents the benchmark measurement.
    """

    measurement: Any
    data: Optional[Any] = None
