import logging
import time

from dataclasses import dataclass
from typing import Callable
from typing import List
from typing import Optional

from bencher.bencher import Bench
from bencher.bencher import BenchMeasurement
from bencher.matcher.matcher import Match

logger = logging.getLogger(__name__)

class ExecutionTime(Bench):
    """A class for measuring the execution time.
    """

    def __init__(self, wall: Optional[int] = None):
        """Initialize the `ExecutionTime`.
        """

        self.wall = wall

    def benchmark(self, callback: Callable[[], List[Match]]) -> BenchMeasurement:
        """Benchmark the execution time.
        """

        start = time.perf_counter_ns()
        data = callback()
        duration = time.perf_counter_ns() - start

        m = BenchMeasurement(
            measurement=ExecutionTimeResult(
                elapsed=duration
            ),
            data=data,
        )

        # Add logging.
        #
        # This logging outputs the resulting benchmark measurement computed after
        # running it.
        logger.debug(f"callback={callback.__module__} measurement={m.measurement}")

        return m


@dataclass
class ExecutionTimeResult:
    """Represents the execution time result.
    """

    elapsed: int
