import pandas as pd

from abc import abstractmethod
from pydantic import BaseModel
from typing import List

from bencher.matcher import Matcher as BaseMatcher
from bencher.matcher import DataStream
from bencher.matcher import MatchResults

class Matcher(BaseMatcher):
    """Represents a Large-Language Model matcher interface.
    """

    def format(self, datastream: DataStream) -> str:
        """Format the data into a CSV-styled structure.
        """

        rows = []
        for frame in datastream.frames:
            for annotation in frame.annotations:
                rows.append([
                    frame.index,
                    annotation.label,
                    annotation.score,
                    annotation.bbox.xmin,
                    annotation.bbox.ymin,
                    annotation.bbox.xmax,
                    annotation.bbox.ymax,
                ])

        return pd.DataFrame(
            data=rows,
            columns=[
                "frame",
                "label",
                "score",
                "xmin",
                "ymin",
                "xmax",
                "ymax"
            ]
        ).to_csv(index=False)


class Match(BaseModel):
    """A match result for an LLM system.
    """

    start: int
    end: int


class StructuredResponse(BaseModel):
    """The structured output for an LLM system.
    """

    nmatches: int
    matches: List[Match]
