from __future__ import annotations

from abc import ABC
from abc import abstractmethod
from dataclasses import dataclass
from typing import List
from typing import Optional


class Matcher(ABC):
    """An interface for matchers.
    """

    @abstractmethod
    def run(self, datastream: DataStream) -> List[Match]:
        """Run the matcher.
        """

        raise NotImplementedError


@dataclass
class BoundingBox:
    """Represents a bounding box region.
    """

    xmin: float
    ymin: float
    xmax: float
    ymax: float


@dataclass
class Annotation:
    """Represents a single annotation.
    """

    label: str
    identifier: str
    score: float
    bbox: BoundingBox


@dataclass
class Frame:
    """Represents a set of data for a single frame of a video.
    """

    index: int
    annotations: List[Annotation]


@dataclass
class DataStream:
    """Represents a stream of data from a video.
    """

    version: Optional[str]
    frames: List[Frame]


@dataclass
class MatchResults:
    """Represents a set of matches found.
    """

    matches: Optional[List[Match]]


@dataclass
class Match:
    """Represents a range of matching data.
    """

    start: int
    end: int
