import logging

logger = logging.getLogger(__package__)
logger.setLevel(logging.DEBUG)
logger.propagate = False

handler = logging.StreamHandler()
handler.setFormatter(logging.Formatter("%(asctime)s: %(levelname)-8s: %(name)-40s: %(message)-20s"))

logger.addHandler(handler)

handler = logging.FileHandler(filename=f"{__package__}.log", mode="a", encoding="utf-8")
handler.setFormatter(logging.Formatter("%(asctime)s: %(levelname)-8s: %(name)-40s: %(message)-20s"))

logger.addHandler(handler)
