#!/bin/bash

# List of molecule names to run
molecules=(
    "revised benzene"
    "revised uracil"
    "revised naphthalene"
    "revised aspirin"
    "revised salicylic acid"
    "revised malonaldehyde"
    "revised ethanol"
    "revised toluene"
    "revised paracetamol"
    "revised azobenzene"
)

splits=(
    "01"
    "02"
    "03"
    "04"
    "05"
)

transformed_balance=(
    0.0
    0.25
    0.5
    0.75
    1.0
)

# Path to your Python script
script_name="main.py"
save_base_dir="md17_results"
# Iterate over each molecule name
# Iterate over each molecule, split, and transformed_balance value
for molecule in "${molecules[@]}"; do
    for split in "${splits[@]}"; do
        for balance in "${transformed_balance[@]}"; do
            save_dir="$save_base_dir/${molecule// /_}/split_$split/balance_$balance"
            echo "Running script for molecule: $molecule, split: $split, balance: $balance"
            python $script_name dataset=md17_detection training.use_wandb=False ++dataset.mol_name="'$molecule'" ++dataset.split_args.train_indices="configs/dataset/md17_splits/index_train_$split.csv" ++dataset.split_args.test_indices="configs/dataset/md17_splits/index_test_$split.csv" ++dataset.augment_args.transform=$balance ++save_dir=$save_dir ++training.epochs=50
            echo "Finished processing molecule: $molecule, split: $split, balance: $balance"
            echo "-------------------------------------------------------------"
        done
    done
done

echo "All molecules, splits, and transformed balances have been processed."
echo "All molecules have been processed."
