#!/bin/bash

# List of molecule names to run
filter_mol=(
    None
    2
)

transformed_balance=(
    0.0
    0.25
    0.5
    0.75
    1.0
)

split_seeds=(
    0
    42
    568
    931
    2048
)

# Path to your Python script
script_name="main.py"
save_base_dir="oc20_results"
# Iterate over each molecule name
# Iterate over each molecule, split, and transformed_balance value
for mol in "${filter_mol[@]}"; do
    for split_seed in "${split_seeds[@]}"; do
        for balance in "${transformed_balance[@]}"; do
            save_dir="$save_base_dir/filter_${mol}/split_seed_$split_seed/balance_$balance"
            echo "Running script for filter mol: $mol, split: $split_seed, balance: $balance"
            python $script_name dataset=oc20_detection ++dataset.filter_mol=$mol training.use_wandb=False ++dataset.augment_args.transform=$balance ++save_dir=$save_dir ++training.epochs=50 ++training.split_seed=$split_seed
            echo "Finished processing molecule: filter mol: $mol, split: $split_seed, balance: $balance"
            echo "-------------------------------------------------------------"
        done
    done
done

echo "All molecules, splits, and transformed balances have been processed."
echo "All molecules have been processed."
