#!/bin/bash

split_seeds=(0 42 568 931)
properties=("mu" "alpha" "homo" "lumo" "gap" "r2" "zvpe" "U0" "U" "H" "G" "Cv")

for seed in "${split_seeds[@]}"; do
  for prop in "${properties[@]}"; do
    job_script=$(mktemp)

    cat <<EOF > "$job_script"
#!/bin/bash
#SBATCH -J qm9_${prop}_${seed}
#SBATCH -A m4064
#SBATCH -q regular
#SBATCH -t 8:00:00        
#SBATCH -N 1          
#SBATCH -C gpu&hbm80g
#SBATCH --gpus-per-task=1
#SBATCH --ntasks-per-node=1
#SBATCH -o qm9_${prop}_${seed}.out
#SBATCH -e qm9_${prop}_${seed}.err

module load conda
conda activate symm_breaking

python main.py \
  +save_dir="${prop}_graphormer_qm9atomicdataset_seed${seed}_noaug" \
  ++training.epochs=500 \
  ++training.use_wandb=True \
  ++dataset.split_args.split_type='anderson' \
  ++training.split_seed="${seed}" \
  ++training.training_seed="${seed}" \
  ++dataset.target="${prop}" \
  ++dataset.name='qm9_atomic' \
  ++training.learning_rate=1e-5
EOF

    sbatch "$job_script"
    rm "$job_script"
  done
done