import json
import random


with open("agentica-org/DeepScaleR-Preview-Dataset/deepscaler.json", 'r', encoding='utf-8') as f:
    data = json.load(f)

prompt = '''
Given the problem, reason and give a final answer to the problem.
You first think about the reasoning process as an internal monologue and then provide the user with the answer. Respond in the following format: <think>
...
</think>
<answer>
...
</answer>.

Here are examples.

Q: What is the degree of the polynomial $(4 +5x^3 +100 +2\pi x^4 + \sqrt{10}x^4 +9)$?

  A: <think>
This polynomial is not written in standard form. However, we don't need to write it in standard form, nor do we need to pay attention to the coefficients. We just look for the exponents on $x$. We have an $x^4$ term and no other term of higher degree, so $\boxed{4}$ is the degree of the polynomial.
</think>
<answer>
4
</answer>

Q: Evaluate $\left\lceil3\left(6-\frac12\right)\right\rceil$.

  A: <think>
Firstly, $3\left(6-\frac12\right)=18-1-\frac12=17-\frac12$. Because $0\le\frac12<1$, we have $\left\lceil17-\frac12\right\rceil=\boxed{17}$.
</think>
<answer>
17
</answer>

Q: {{question}}

  A:
'''.strip()

for d in data:
    d["instruction"] = prompt.replace("{{question}}", d["problem"])
    d["input"] = ""
    d["output"] = ""
    d.pop("problem")
    d.pop("solution")

data = random.sample(data, 5000)

with open("agentica-org/DeepScaleR-Preview-Dataset/deepscaler-5000.json", 'w', encoding='utf-8') as f:
    json.dump(data, f, ensure_ascii=True, indent=4)
