﻿### Installation

#### conda
We provide an environment file; ``environment.yml`` containing the required dependencies. Run the following command in the root of this directory:
```
conda env create -f environment.yml
```
If you would like to install pytorch without cuda, instead run:
```
conda env create -f environment-nocuda.yml
```

### Repository Structure
This repository is organized as follows:
- ``ckconv`` contains the main PyTorch library of our model.
- ``models`` contains the model architectures used in our experiments.
- ``datamodules`` contains the pytorch lightning datamodules used in our experiments.
- ``cfg`` contains the configuration file in which to specify default arguments to be passed to the script.

### Using the code

All experiments are run with `main.py`. Flags are handled by [Hydra](https://hydra.cc/docs/intro).
See `cfg/config.yaml` for all available flags. Flags can be passed as `xxx.yyy=value`.

#### Useful flags

- `net.*` describes settings for the models (model definition `models/resnet.py`).
- `kernel.*` describes settings for the MAGNet kernel generator networks.
- `mask.*` describes settings for the FlexConv Gaussian mask.
- `conv.*` describes settings for the convolution operation. It can be used to switch between FlexConv, CKConv, regular Conv, and their separable variants.
- `dataset.*` specifies the dataset to be used, as well as variants, e.g., permuted, sequential.
- `train.*` specifies the settings used for the Trainer of the models.
- `train.do=False`: Only test the model. Useful in combination with pre-training.
- `optimizer.*` specifies and configures the optimizer to be used.
- `debug=True`: By default, all experiment scripts connect to Weights & Biases to log the experimental results. Use this flag to run without connecting to Weights & Biases.
- `pretrained.*`: Use these to load checkpoints before training.

### Reproducing experiments
Please see the [experiments README](/experiments/README.md) for details on reproducing the paper's experiments.
