#!/bin/bash
#SBATCH --account=xxx
#SBATCH --job-name=linear_classification
#SBATCH --nodes=1
#SBATCH --output=xxx
#SBATCH --error=xxx
#SBATCH --time=12:00:00      
#SBATCH --partition=gengpu   
#SBATCH --gres=gpu:h100:1      
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=16
#SBATCH --open-mode=append
#SBATCH --mem=60G
#SBATCH --mail-type=ALL
#SBATCH --mail-user=xxx ## your email


module purge all
module load gcc/11.2.0
eval "$(conda shell.bash hook)"
conda activate ag
cd xxx


for seed in 42; do
    # python linear_classifier.py --input_embs /xxx/csdr1_raw4_catflags_filtered_embs_chronos_bolt_tiny_trn_val_tst_ctx200_bandgr --scenario concat --seed $seed
    # python linear_classifier.py --input_embs /xxx/csdr1_raw_embs_moiral_small_trn_val_tst_ctx200_pdt64_psz16_bandgr --scenario concat --seed $seed
    # python linear_classifier.py --input_embs /xxx/hf_csdr1_multiband_raw4_embeddings_astromer_1_subclass_pad_correct --scenario concat --seed $seed
    # python linear_classifier.py --input_embs /xxx/hf_csdr1_multiband_raw4_embeddings_astromer_2_gr_sampling_True --scenario concat --seed $seed
    python linear_classifier.py --input_embs /xxx/csdr1_raw4_catflags_filtered_embs_hand_crafted_trn_val_tst_bandgr --scenario concat --hand_crafted 1 --seed $seed
    # python linear_classifier.py --input_embs /xxx/random --scenario concat --seed $seed
done


