# TART: A plug-and-play Transformer module for task-agnostic reasoning


## Getting started
You can start by cloning our repository and following the steps below.

1. Install the dependencies for our code using Conda. You may need to adjust the environment YAML file depending on your setup.

    ```
    conda create --name in-context-learning --file src/requirements.txt
    ```

2. [Optional] If you plan to train, populate `conf/wandb.yaml` with you wandb info.

## Training an reasoning module
* All files needed for training a reasoning module can be found in `src/reasoning_module`. To train a reasoning module, use the following command:

    ```
    python src/reasoning_module/train.py --config src/reasoning_module/conf/tart_heads/reasoning_head_s258.yaml
    ```

* To customize the specifications of the TART Head (i.e., sequence length, training noise etc.), modify parameters in the config file: `reasoning_head_s258.yaml`.

## Evaluating TART
* All utilities needed to evaluate TART can be found in `src/eval`. In `src/`, we provide several bash scripts demonstrating how to evaluate TART on audio, image, and text tasks. We refer user to those scripts. 

## Baselines
* All utilities and scripts needed for training baseline methods (i.e., full fine-tuning, LM head fine-tuning, adapter fine-tuning and last layer fine-tuning) can be found in `src/baselines`. We provide several bash scripts in `src` (i.e., `src/finetune_baselines_text.sh` and `src/run_hyperparameter_search.sh`) demonstrating how to use the utility functions.